#pragma once

#ifndef		CONFIGSTY_H
#define		CONFIGSTY_H

#include <afxmt.h>
#include "Config.h"

/////////////////////////////////////////////////////////////////////////////
#define kCfgEventStateChange		10000
/////////////////////////////////////////////////////////////////////////////
/*******************/
/* Security states */
/*******************/
enum EStyState{
	eStyReady = 0,
	eStyPin1CodeExpected,
	eStyPin2CodeExpected,
	eStyPuk1CodeExpected,
	eStyPuk2CodeExpected,
	eStyPhoneToSimCodeExpected,
	eStyPhoneToFirstInsertedSimCodeExpected,
	eStyPhoneToFirstInsertedSimPukCodeExpected,
	eStyLastCodeExpected
};

#define	kStyStateKey					"State"
#define	kStyPin1Key						"Pin"
#define	kStyPin1NumTriesKey				"PinNumTries"
#define	kStyPin2Key						"Pin2"
#define	kStyPin2NumTriesKey				"Pin2NumTries"
#define	kStyPuk1Key						"Puk"
#define	kStyPuk1NumTriesKey				"Puk1NumTries"
#define	kStyPuk2Key						"Puk2"
#define	kStyPuk2NumTriesKey				"Puk2NumTries"
#define	kStyPhoneToSimCodeKey			"PhoneToSim"
#define	kStyPhoneToFirstSimCodeKey		"PhoneToFirstSim"
#define	kStyPhoneToFirstSimPukCodeKey	"PhoneToFirstSimPuk"

#define	kStyDefaultState				eStyPin1CodeExpected
#define	kStyDefault4DigitsPwd			"0000"
#define	kStyDefault8DigitsPwd			"00000000"

//#define	kPinCodeLength					8
#define kPinCodeMinLength					4
#define kPinCodeMaxLength					8
#define kPukCodeMinLength					8
#define kPukCodeMaxLength					8


#ifdef DLLMANAGER_EXPORTS
	#define DLLMANAGER_API __declspec(dllexport)
#else
	#define DLLMANAGER_API __declspec(dllimport)
#endif

struct StructSTYCode
{
	CString code;
	int numtry;
};

class DLLMANAGER_API CConfigSTY : public CConfig
{
private :
	StructSTYCode* mCode;
	int mState;
	int mDefaultPinNumTries;
	int mDefaultPukNumTries;
	int mPIN2Entered;

protected:
	DECLARE_SERIAL(CConfigSTY);
public:
	CConfigSTY() {};
	CConfigSTY(CDllManager* iDllManager);
	virtual ~CConfigSTY(void);
	virtual Bool Load();
	virtual Bool Save();
	virtual void Init();
	virtual void InitDefault();	
	// Set
	virtual void SetState(int iState);		
	virtual void SetNumTries(EStyState iState, int nTry);
	virtual void SetCode(EStyState iState, CString iCode);
	virtual void SetCode(CString iCode);
	virtual void SetPIN2Entered(int iStatus);
	virtual void SetCLCKSC(int iMode);
	// Get
	virtual int GetState();
	virtual int GetNumTries();
	virtual int GetNumTries(EStyState iState);	
	virtual CString GetCode();
	virtual CString GetCode(EStyState iState);
	virtual int	GetDefaultPinNumTries();
	virtual int	GetDefaultPukNumTries();
	virtual int	GetCLCKSC();
	// return 
	virtual int IsPIN2Entered();
	// return required feature according to iState
	virtual int GetStateError(int iState);
	// return true if pwd1==pwd2, change state if necessary if numtries is reached
	// PasswdType is EStyState to indicate what kind of passwd is being compared or -1 if other
	// return -1 if no error, else error number
	virtual int IsSamePassword(int iPasswdType, CString iPasswd1, CString iPasswd2);
	// check if iCode has a correct syntax, return error number, -1 if ok
	virtual int IsCodeValid(CString iCode, EStyState iCodeType);
	// use un try
	virtual int UseNumTry();
	virtual int UseNumTry(EStyState iState);

	virtual void Serialize(CArchive& ar);
};

#endif
